
public class TEA {
    /**
     * value is 0xffffffff
     * filter long to unsigned int
     */
    public static Long UIFILTER = Long.decode("0xffffffff");
    /**
     * value is 0xff
     * filter short to unsigned byte
     */
    public static Short UBFILTER = Short.decode("0xff");

    /**
     * Encipher method
     * <p>
     * 64bit plaintext, 128bit key
     *
     * @param v Plaintext
     * @param k Key
     * @return
     */
    public static Short[] encipher(Short[] v, Short[] k) {
        Long[] vL = shortToLong(v);
        Long[] kL = shortToLong(k);
        Long[] wL = new Long[vL.length];
        Short[] w = null;
        long y = vL[0];
        long z = vL[1];
        long a = kL[0];
        long b = kL[1];
        long c = kL[2];
        long d = kL[3];
        long n = 0x08; /* do encrypt 16 (0x08+) times */
        long sum = 0;
        long delta = Long.decode("0x9E3779B9"); /* 0x9E3779B9 - 0x100000000 = -0x61C88647 */
        while (n-- > 0) {
            sum += delta;
            sum &= UIFILTER;
            y += ((z << 4) + a) ^ (z + sum) ^ ((z >> 5) + b);
            y &= UIFILTER;
            z += ((y << 4) + c) ^ (y + sum) ^ ((y >> 5) + d);
            z &= UIFILTER;
        }
        wL[0] = y;
        wL[1] = z;
        w = longToShort(wL);
        return w;
    }

    /**
     * Decipher method <br>
     * <p>64bit ciphertext, 128bit key
     *
     * @param v Ciphertext
     * @param k Key
     * @return
     */
    public static Short[] decipher(Short[] v, Short[] k) {
        Long[] vL = shortToLong(v);
        Long[] kL = shortToLong(k);
        Long[] wL = new Long[vL.length];
        Short[] w = null;
        long y = vL[0];
        long z = vL[1];
        long a = kL[0];
        long b = kL[1];
        long c = kL[2];
        long d = kL[3];
        long n = 0x08;
        /* sum = delta << 4, in general sum = delta * n */
        long delta = Long.decode("0x9E3779B9");
        //        long sum = Long.decode("0xE3779B90")/2;
        long sum = delta * n;

        // use filter to get unsigned int
        // use ~x +1 instead -x
        while (n-- > 0) {
            z += (~(((y << 4) + c) ^ (y + sum) ^ ((y >> 5) + d)) + 1);
            z &= UIFILTER;
            y += (~(((z << 4) + a) ^ (z + sum) ^ ((z >> 5) + b)) + 1);
            y &= UIFILTER;
            sum += ((~delta) + 1);
            sum &= UIFILTER;
        }

        wL[0] = y;
        wL[1] = z;
        w = longToShort(wL);
        return w;
    }

    /**
     * convert bytes to longs, put every 4 bytes to 1 long
     * <p>
     * use long instead unsigned int
     * use short instead unsigned byte
     *
     * @param source - the Short [] that save unsigned bytes to convert
     * @return the Long [] save unsigned int
     */
    public static Long[] shortToLong(Short[] source) {
        int sourlen = source.length;
        int turn = sourlen / 4; // how many turns
        int remainder = sourlen % 4; // how many bytes in first turn
        int tarlen = turn + (remainder == 0 ? 0 : 1);
        Long[] target = new Long[tarlen];
        for (int i = 0; i < target.length; i++) {
            target[i] = Long.parseLong("0");
        }
        int iter = 0;
        int turnIter = 0;
        for (turnIter = 0; turnIter < tarlen; turnIter++) {
            for (iter = 0; iter < 4; iter++) {
                Long[] arrayOfLong = target;
                int j = turnIter;
                arrayOfLong[j] = Long.valueOf(arrayOfLong[j].longValue() << 8);
                Long.valueOf(arrayOfLong[j].longValue() << 8);
                if (turnIter != turn - 1 || (turnIter == turn - 1 && (iter < remainder || remainder == 0))) {
                    arrayOfLong = target;
                    j = turnIter;

                    arrayOfLong[j] = Long.valueOf(arrayOfLong[j].longValue() + source[turnIter * 4 + (3 - iter)].shortValue());
                    Long.valueOf(arrayOfLong[j].longValue() + source[turnIter * 4 + (3 - iter)].shortValue());
                }
            }
        }
        return target;
    }

    /**
     * convert longs to bytes
     * <p>
     * cut 1 long(32bit valid to instead unsigned int) to 4 short(8bit valid to instead unsigned byte)
     * use long instead unsigned int
     * use short instead unsigned byte
     *
     * @param source - the Long [] that save unsigned int to convert
     * @return the Short [] that save unsigned bytes
     */
    public static Short[] longToShort(Long[] source) {
        int sourlen = source.length;
        Short[] target = new Short[sourlen * 4];
        int turn = target.length % 4;
        int iter = 0;
        int move = 0;
        for (iter = 0; iter < target.length; iter++) {
            //move = 8 * (3 - (iter % 4)); // 大端
            move = 8 * (iter % 4); // 小端
            target[iter] = Short.parseShort(Long.toString((source[iter / 4] & (UBFILTER << move)) >> move));
        }
        return target;
    }
}