import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TEADemo {

    /**
     * 将字符串转换为Short
     * 字符串长度为8字节即16个字母
     * @param a
     * @return
     */
    private static Short[] convertFromString(String a) {
        if (a.length() % 8 == 0) {
            Short[] ret = new Short[a.length()/2];
            for (int i = 0; i < a.length() / 2; i++) {
                ret[i] = Short.decode("0x" + a.substring(i * 2, (i + 1) * 2));
            }
            return ret;
        }
        throw new RuntimeException("input string invalid, please check");
    }

    public static void main(String[] args) {

        Long[] keyLongs = new Long[4];
        keyLongs[0] = Long.decode("0x78563412");
        keyLongs[1] = Long.decode("0x01efbc9a");
        keyLongs[2] = Long.decode("0x89674523");
        keyLongs[3] = Long.decode("0xefdecdab");

        Short[] key = TEA.longToShort(keyLongs);

        // 完整指令 E000000DC1C2C3C4C5C616101914201A0F
        // 需要加密的数据 C1C2C3C4C5C6 16101914201A 0F
        List<String> list = new ArrayList<>();
        list.add("C1C2C3C4C5C61610");
        list.add("1914201A0F000000");

        list.forEach(str -> {
            Short[] shorts = convertFromString(str); // 将字符串转换为Short
            Short[] secretInfo = TEA.encipher(shorts, key); // 加密
            System.out.println("secretInfo="+ Arrays.toString(secretInfo));

            String cmdStr = "";
            for (int i32Index = 0; i32Index < secretInfo.length; i32Index++) {
                System.out.print("0x" + Integer.toHexString(secretInfo[i32Index] & 0xff) + " ");
                cmdStr = cmdStr + StringUtils.leftPad(Integer.toHexString(secretInfo[i32Index] & 0xff) + "", 2, "0");
            }
            System.out.println(cmdStr);
        });
        // E000000D fcb5d241d716cb0b3d118bdc88664271
    }
}
