// index.js
// 获取应用实例
const app = getApp()
import {
  SendBleCmdHex,
  subscribeBluetoothNotify
} from "../../utils/wechat-ble";

Page({
  data: {
    isConnected: false,
    device: {
    },
    hexStr01: '0100000dA2B2D5D4EA5015050F161920bd',
    hexStrE0: 'E000000DC05B361276D8410ED4E583CF04D60972',
    receiveList: []
  },
  /**
   * 01指令输入框
   * @param {*} options
   */
  hexStrInput01: function (options) {
    //获取输入框输入的内容
    let value = options.detail.value;
    // console.log("输入框输入的内容是 " + value)
    this.setData({
      hexStr01: value
    })
  },
  /**
   * E0指令输入框
   * @param {*} options
   */
  hexStrInputE0: function (options) {
    //获取输入框输入的内容
    let value = options.detail.value;
    // console.log("输入框输入的内容是 " + value)
    this.setData({
      hexStrE0: value
    })
  },
  clearReceiveStrClick() {
    this.setData({
      receiveList: []
    })
  },
  send01() {
    if (!this.data.hexStr01) return
    this.sendBleDataClick(this.data.hexStr01)
  },
  sendE0() {
    if (!this.data.hexStrE0) return
    this.sendBleDataClick(this.data.hexStrE0)
  },
  /**
   * 发送蓝牙信息
   */
  sendBleDataClick(hexStr) {
    console.log(`sendBleDataClick hexStr=${hexStr}`)
    if (!hexStr) return

    SendBleCmdHex(hexStr,
      this.data.device.deviceId,
      this.data.device.serviceId,
      this.data.device.writeCharacteristicsId).then(res => {
      console.log(`SendBleCmdHex res=`, res)
      wx.showToast({
        title: `发送成功`,
        icon: 'success',
        duration: 500
      })
    }).catch(err => {
      console.log(`SendBleCmdHex err=`, err)
      wx.showModal({
        title: `发送失败`,
        content: err.errMsg,
        showCancel: false
      })
    })
  },
  showTipsModal(title = '提示', content) {
    wx.showModal({
      title: title,
      content: content,
      showCancel: false
    })
  },
  onLoad(options) {
    console.log(`device options=`, options)
    this.setData({
      device: JSON.parse(options.device)
    })
    // this.setData({
    //   isConnected: true,
    //   device: {
    //     deviceId: deviceId,
    //     services: services,
    //     characteristics: characteristics
    //   }
    // })

    // 启用消息监听
    subscribeBluetoothNotify(this.data.device.notifyCharacteristicsId, this.data.device.deviceId, this.data.device.serviceId, (notifyRes) => {
      console.log(`接收到蓝牙消息 notifyRes=`, notifyRes)
      const arr = this.data.receiveList
      arr.push(notifyRes)
      this.setData({
        receiveList: arr
      })
    })
  }
})
