// index.js
// 获取应用实例
const app = getApp()
import {
  openBLEAdapter,
  scanBluetoothDevices,
  getBluetoothDevicesList,
  createBLEConnection,
  getBLEDeviceServices,
  stopBluetoothDevicesDiscovery,
  getBLEDeviceCharacteristics
} from "../../utils/wechat-ble";

Page({
  data: {
    deviceList: [
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      },
      {
        deviceName: '张三丰',
        RSSI: -89,
        mac: 'A3D3D3D3D3D3',
        deviceId: '999328423-329933-323433-82930023493'
      }
    ]
  },
  // todo 开启蓝牙适配器
  openBleAdapterClick() {
    openBLEAdapter().then(res => {
      console.log(`openBLEAdapter res=`, res)
      wx.showToast({
        title: `开启成功`,
        icon: 'success',
        duration: 1000
      })
    }).catch(err => {
      wx.showToast({
        title: err,
        icon: 'fails',
        duration: 1000
      })
    })
  },
  // todo 开始扫描蓝牙设备
  async startSearchBluetoothDevicesClick() {
    const res = await scanBluetoothDevices()
    wx.showToast({
      title: `开始扫描蓝牙设备`,
      icon: 'success',
      duration: 1000
    })
    console.log(`开始扫描蓝牙设备 res=`, res)
  },
  // todo 停止扫描蓝牙设备
  async stopSearchBluetoothDevicesClick() {
    const res = await stopBluetoothDevicesDiscovery()
    wx.showToast({
      title: `停止扫描蓝牙设备`,
      icon: 'success',
      duration: 1000
    })
    console.log(`停止扫描蓝牙设备 res=`, res)
  },
  // todo 获取已经扫描到的设备列表
  async getBluetoothDevicesListClick() {
    const list = await getBluetoothDevicesList(false)
    console.log(`已经扫描到的设备列表 list=`, list)
    wx.showToast({
      title: `获取已扫描设备`,
      icon: 'success',
      duration: 1000
    })

    this.setData({
      deviceList: list
    })
  },
  // todo 连接指定的蓝牙设备
  async createBleConnect(e) {
    const device = e.currentTarget.dataset.device
    console.log(`连接蓝牙设备 device=`, device)
    const deviceId = device.deviceId

    this.stopSearchBluetoothDevicesClick()

    // 连接指定的蓝牙设备
    wx.showLoading({ title: '正在连接...', mask: true })
    const bleConnection = await createBLEConnection(deviceId).catch(err => {
      this.showTipsModal('连接蓝牙设备失败', err.errMsg)
    })
    if (!bleConnection) return
    console.log('bleConnection > ', bleConnection)

    // 获取BLE设备ServiceId
    wx.showLoading({ title: '正在获取服务...', mask: true })
    const services = await getBLEDeviceServices('FFF0', deviceId).catch(err => {
      this.showTipsModal('获取设备ServiceId失败', err.errMsg)
      return
    })
    if (!services) return
    console.log('BLE设备ServiceId > ', services)

    // 获取蓝牙设备服务中特征值
    wx.showLoading({ title: '正在获取特征值...', mask: true })
    const characteristics = await getBLEDeviceCharacteristics(deviceId, services.serviceId).catch(err => {
      this.showTipsModal('获取设备特征值失败', err.errMsg)
      return
    })
    if (!characteristics) return
    console.log('characteristics > ', characteristics)

    // // 启用消息监听
    // await subscribeBluetoothNotify(characteristics.notifyCharacteristicsId, deviceId, services.serviceId, (notifyRes) => {
    //   console.log(`接收到蓝牙消息 notifyRes=`, notifyRes)
    // })

    const params = {
      deviceName: device.deviceName,
      filterName: device.filterName,
      localName: device.localName,
      name: device.name,
      mac: device.mac,
      sn: device.sn,
      RSSI: device.RSSI,
      deviceId: deviceId,
      serviceId: services.serviceId,
      notifyCharacteristicsId: characteristics.notifyCharacteristicsId,
      writeCharacteristicsId: characteristics.writeCharacteristicsId,
    }

    wx.hideLoading()
    wx.showToast({
      title: `连接成功`,
      icon: 'success',
      duration: 1000
    })
    wx.navigateTo({
      url: `/pages/device/index?device=${JSON.stringify(params)}`
    })
  },
  showTipsModal(title = '提示', content) {
    wx.showModal({
      title: title,
      content: content,
      showCancel: false
    })
  },
  onLoad() {
  }
})
